use cedar_rust_sdk::CedarClient;

#[tokio::main]
async fn main() -> anyhow::Result<()> {
    let mut c = CedarClient::new(
        &std::env::var("CEDAR_BASE_URL").unwrap_or_else(|_| "https://www.cedarcloud.app".to_string()),
        &std::env::var("CEDAR_APP_ID").unwrap_or_else(|_| "app_replace_me".to_string()),
        &std::env::var("CEDAR_APP_SECRET").unwrap_or_else(|_| "replace_me".to_string()),
        "1.0.0",
    );
    println!("{}", c.health().await?);
    println!("{}", c.login(&std::env::var("CEDAR_USER").unwrap_or_else(|_| "admin".to_string()), &std::env::var("CEDAR_PASS").unwrap_or_else(|_| "1029Aztra!!".to_string())).await?);
    println!("{}", c.heartbeat().await?);
    println!("{}", c.sdk_init("rust-example-device", "rust-hwid").await?);
    println!("{}", c.activate_license(&std::env::var("CEDAR_LICENSE").unwrap_or_else(|_| "LIC-REPLACE".to_string()), "rust-example-device", "rust-hwid").await?);
    println!("{}", c.sdk_heartbeat().await?);
    println!("{}", c.validate().await?);
    Ok(())
}
