local M = {}

local function encode_json(tbl)
  local ok, json = pcall(function() return require('dkjson') end)
  if ok and json then return json.encode(tbl) end
  error('dkjson is required for cedar_lua_sdk')
end

local function decode_json(raw)
  local ok, json = pcall(function() return require('dkjson') end)
  if ok and json then
    local obj = json.decode(raw)
    return obj or {}
  end
  return {}
end

function M.new(cfg)
  local self = {
    base_url = (cfg.base_url or ''):gsub('/$', ''),
    app_id = cfg.app_id or '',
    app_secret = cfg.app_secret or '',
    sdk_version = cfg.sdk_version or '1.0.0',
    token = '',
    sdk_token = '',
    entitlement = '',
    signature_b64 = '',
  }

  function self:request(path, method, body, bearer)
    local curl = io.popen(string.format(
      "curl -s -X %s '%s%s' -H 'Content-Type: application/json' %s %s",
      method or 'GET',
      self.base_url,
      path,
      bearer and ("-H 'Authorization: Bearer " .. bearer .. "'") or '',
      body and ("-d '" .. encode_json(body):gsub("'", "'\\''") .. "'") or ''
    ))
    local raw = curl:read('*a')
    curl:close()
    return decode_json(raw)
  end

  function self:health() return self:request('/health', 'GET', nil, nil) end

  return self
end

return M
