# CEDAR SDK Integration Guide

## 1) Initialize the client

```cpp
cedar::api sdk("MyApp", "app_id", "app_secret", "1.0.0", "https://api.example.com", true);
```

## 2) Apply security policy

```cpp
cedar::security_policy_t policy;
policy.require_https = true;
policy.allow_localhost_http = false;
policy.verify_entitlement_signature = true;
policy.max_clock_skew_secs = 120;
policy.require_activation_validate_roundtrip = true;
policy.require_subscription_not_expired = true;
sdk.set_security_policy(policy);
```

## 3) Preflight validation

```cpp
if (!sdk.preflight()) {
  // sdk.response().message
}
```

## 4) Optional endpoint overrides

```cpp
sdk.set_endpoint("sdk_init", "/api/sdk/init");
```

## 5) Connect and activate

```cpp
if (!sdk.init()) {
  // sdk.response().message
}
if (!sdk.license("LIC-XXXX")) {
  // sdk.response().message
}
```

## 6) Keep session alive

```cpp
if (!sdk.check()) {
  // terminate access
}
```

## 7) Optional custom calls

```cpp
sdk.custom_call("POST", "endpoint:sdk_heartbeat", "{}", false, true, true);
```

## 8) Optional secured profile loading

```cpp
sdk.load_profile_from_env("CEDAR");
// or sdk.load_profile_from_encrypted_blob(profile_blob_b64, decrypt_secret);
```
