# CEDAR SDK API Alignment

This SDK is aligned to the current backend routes:

- `POST /api/sdk/init`
- `POST /api/sdk/license/activate`
- `POST /api/sdk/license/deactivate`
- `POST /api/sdk/heartbeat`
- `GET /api/sdk/license/validate`
- `POST /api/auth/login`
- `POST /api/auth/register`
- `POST /api/auth/heartbeat`
- `POST /api/auth/logout`
- `POST /api/sdk/log`
- `POST /api/public/license-abuse-report`
- `GET /api/public/announcements`
- `GET /api/public/status`
- `GET /api/sdk/announcements`

If routes change, update at runtime with `set_endpoint(name, path)`.

## Backend request constraints reflected by SDK

- init nonce length must be >= 12.
- activation requires:
  - `device_id` length >= 8
  - `nonce` length >= 12
- login/register include optional telemetry payload:
  - `discord_tag`, `hwid`, `machine_id`, `device_uuid`, `gpu_name`, `reg_info`
  - `os_name`, `os_version`, `cpu_model`, `host_name`
- activation includes `device_profile`:
  - `os_name`, `os_version`, `cpu_model`, `cpu_cores`, `ram_mb`, `gpu_name`, `motherboard`, `host_name`

## Response schema checks

SDK validates minimum response schema for:

- init
- login
- register
- activate
- heartbeat
- validate
- deactivate
- public status
- announcements
